{{-- resources/views/candidates/show.blade.php --}}
@extends('layouts.app')

@section('title', 'Detail Kandidat')
@section('page-title', 'Detail Kandidat')

@push('styles')
  {{-- External --}}
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  {{-- Custom --}}
  <link href="{{ asset('css/candidate-detail.css') }}" rel="stylesheet">
  <link href="{{ asset('css/disc-3d-styles.css') }}" rel="stylesheet">

  {{-- Sticky Nav + ScrollSpy Styles --}}
  <style>
    :root{
      /* akan diisi JS sesuai tinggi header nyata */
      --stickTop: 72px;     /* jarak dari atas (di bawah header) */
      --navWidth: auto;     /* dipakai saat fallback fixed */
      --navLeft: 0px;       /* dipakai saat fallback fixed */
      --navHeight: 0px;     /* buat spacer agar tidak lompat layout */
    }

    .section-nav{
      position: sticky;
      top: var(--stickTop);
      z-index: 60;
      background: #fff;
      border-radius: 12px;
      padding: 8px 12px;
      margin: 16px 0 24px;
      box-shadow: 0 8px 24px rgba(0,0,0,.06);
    }
    /* Fallback jika parent ber-overflow: nav diganti fixed */
    .section-nav.is-fixed{
      position: fixed !important;
      top: var(--stickTop);
      left: var(--navLeft);
      width: var(--navWidth);
      box-shadow: 0 10px 28px rgba(0,0,0,.08);
    }
    /* spacer supaya layout tidak "melompat" saat nav jadi fixed */
    #sectionNavSpacer{ height: 0px; }

    .section-nav-list{
      display:flex; flex-wrap:wrap; gap:8px 16px; list-style:none; padding:0; margin:0;
    }
    .section-nav-item{ margin:0; }
    .section-nav-link{
      display:inline-flex; align-items:center; gap:8px;
      padding:10px 14px; border-radius:10px;
      color:#334155; text-decoration:none; font-weight:600;
      transition: background .2s, color .2s, transform .08s;
      user-select:none;
    }
    .section-nav-link:hover{ background:#f1f5f9; color:#111827; }
    .section-nav-link:active{ transform:translateY(1px); }
    .section-nav-link.active{
      background:#eef2ff; color:#3730a3; box-shadow: inset 0 0 0 2px #c7d2fe;
    }

    /* Biar saat loncat anchor tidak ketutup header */
    .content-section{ scroll-margin-top: calc(var(--stickTop) + 16px); }

    /* Modal minimal (kalau CSS-mu sudah ada, bagian ini aman diabaikan) */
    .modal{ display:none; position:fixed; inset:0; background:rgba(0,0,0,.4); z-index:1000; }
    .modal.show{ display:block; }
    .modal-content{ background:#fff; border-radius:12px; margin:60px auto; max-width:800px; overflow:hidden; }
    .modal-header{ display:flex; justify-content:space-between; align-items:center; padding:16px 20px; border-bottom:1px solid #e5e7eb; }
    .modal-title{ margin:0; font-size:1.1rem; font-weight:700; }
    .modal-body{ padding:20px; }
    .modal-actions{ display:flex; gap:10px; justify-content:flex-end; padding-top:8px; }
    .modal .close{ cursor:pointer; font-size:1.3rem; padding:4px 8px; border-radius:8px; }
    .muted{ font-size:.8rem; color:#6b7280; font-weight:400; }
  </style>
@endpush

{{-- Tombol2 di kanan topbar (khusus halaman ini) --}}
@section('header-actions')
  <div class="flex items-center gap-2">
    <button class="btn btn-info inline-flex items-center gap-2 px-3 py-2 rounded-md"
            onclick="showHistoryModal()">
      <i class="fas fa-history"></i><span class="hidden md:inline">Riwayat</span>
    </button>

    <a href="{{ route('candidates.preview', $candidate->id) }}"
       class="btn btn-info inline-flex items-center gap-2 px-3 py-2 rounded-md"
       target="_blank">
      <i class="fas fa-eye"></i><span class="hidden md:inline">Export</span>
    </a>

    <a href="{{ route('candidates.edit', $candidate->id) }}"
       class="btn btn-secondary inline-flex items-center gap-2 px-3 py-2 rounded-md">
      <i class="fas fa-edit"></i><span class="hidden md:inline">Edit</span>
    </a>

    <button class="btn btn-primary inline-flex items-center gap-2 px-3 py-2 rounded-md"
            onclick="showStatusModal()">
      <i class="fas fa-sync"></i><span class="hidden md:inline">Update Status</span>
    </button>
  </div>
@endsection

@section('breadcrumb')
  <a href="{{ route('dashboard') }}">Dashboard</a>
  <span>/</span>
  <a href="{{ route('candidates.index') }}">Kandidat</a>
  <span>/</span>
  Detail
@endsection

@section('content')
  {{-- ===== Header Kandidat ===== --}}
  <div class="candidate-header">
    <div class="candidate-banner">
      <div class="candidate-info-header">
        <div class="candidate-photo">
          @php $photoDocument = $candidate->documentUploads->where('document_type', 'photo')->first(); @endphp
          @if($photoDocument)
            <img src="{{ Storage::url($photoDocument->file_path) }}"
                 alt="Foto {{ $candidate->full_name ?? 'Kandidat' }}"
                 style="width:100%;height:100%;object-fit:cover;border-radius:50%;">
          @else
            <i class="fas fa-user"></i>
          @endif
        </div>

        <div class="candidate-details-header">
          <h2 class="candidate-name">{{ $candidate->full_name ?? 'N/A' }}</h2>
          <p class="candidate-position">
            {{ $candidate->position->position_name ?? $candidate->position_applied }}
            @if($candidate->expected_salary)
              • Gaji Harapan: Rp {{ number_format($candidate->expected_salary, 0, ',', '.') }}
            @endif
          </p>
          <div class="candidate-meta">
            <div class="meta-item"><i class="fas fa-id-badge"></i><span>{{ $candidate->candidate_code }}</span></div>
            <div class="meta-item"><i class="fas fa-envelope"></i><span>{{ $candidate->email ?? 'N/A' }}</span></div>
            <div class="meta-item"><i class="fas fa-phone"></i><span>{{ $candidate->phone_number ?? 'N/A' }}</span></div>
            <div class="meta-item">
              <span class="status-badge status-{{ $candidate->application_status }}">
                {{ ucfirst($candidate->application_status) }}
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- ===== Spacer utk fallback fixed ===== --}}
  <div id="sectionNavSpacer"></div>

  {{-- ===== Nav Section (Sticky/Fixed + Clickable) ===== --}}
  <nav class="section-nav" id="sectionNav">
    <ul class="section-nav-list" id="sectionNavList">
      <li class="section-nav-item"><a href="#personal-section"   class="section-nav-link active"><i class="fas fa-user"></i><span>Data Pribadi</span></a></li>
      <li class="section-nav-item"><a href="#education-section"  class="section-nav-link"><i class="fas fa-graduation-cap"></i><span>Pendidikan</span></a></li>
      <li class="section-nav-item"><a href="#experience-section" class="section-nav-link"><i class="fas fa-briefcase"></i><span>Pengalaman</span></a></li>
      <li class="section-nav-item"><a href="#skills-section"     class="section-nav-link"><i class="fas fa-cogs"></i><span>Keterampilan</span></a></li>
      <li class="section-nav-item"><a href="#activities-section" class="section-nav-link"><i class="fas fa-hands-helping"></i><span>Aktivitas</span></a></li>
      <li class="section-nav-item"><a href="#general-section"    class="section-nav-link"><i class="fas fa-info-circle"></i><span>Info Umum</span></a></li>
      <li class="section-nav-item"><a href="#kraeplin-section"   class="section-nav-link"><i class="fas fa-chart-line"></i><span>Hasil Kraeplin</span></a></li>
      <li class="section-nav-item"><a href="#disc-section"       class="section-nav-link"><i class="fas fa-chart-pie"></i><span>Hasil DISC</span></a></li>
      <li class="section-nav-item"><a href="#documents-section"  class="section-nav-link"><i class="fas fa-file-alt"></i><span>Dokumen</span></a></li>
    </ul>
  </nav>

  {{-- ===== Data Pribadi ===== --}}
  <section id="personal-section" class="content-section" style="margin-top:0">
    <h2 class="section-title"><i class="fas fa-user-circle"></i>Data Pribadi</h2>

    <div class="info-grid">
      {{-- Info Dasar --}}
      <div class="info-card">
        <h3 class="info-card-title"><i class="fas fa-id-card"></i>Informasi Dasar</h3>
        <div class="info-row"><span class="info-label">Nama Lengkap</span><span class="info-value">{{ $candidate->full_name ?? 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">NIK</span><span class="info-value">{{ $candidate->nik ?? 'N/A' }}</span></div>
        <div class="info-row">
          <span class="info-label">Tempat, Tanggal Lahir</span>
          <span class="info-value">{{ $candidate->birth_place ?? 'N/A' }}, {{ $candidate->birth_date ? \Carbon\Carbon::parse($candidate->birth_date)->format('d M Y') : 'N/A' }}</span>
        </div>
        <div class="info-row"><span class="info-label">Jenis Kelamin</span><span class="info-value">{{ $candidate->gender ?? 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">Agama</span><span class="info-value">{{ $candidate->religion ?? 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">Status Pernikahan</span><span class="info-value">{{ $candidate->marital_status ?? 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">Suku Bangsa</span><span class="info-value">{{ $candidate->ethnicity ?? 'N/A' }}</span></div>
      </div>

      {{-- Kontak --}}
      <div class="info-card">
        <h3 class="info-card-title"><i class="fas fa-phone-alt"></i>Kontak</h3>
        <div class="info-row"><span class="info-label">Email</span><span class="info-value">{{ $candidate->email ?? 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">No. Telepon</span><span class="info-value">{{ $candidate->phone_number ?? 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">No. Alternatif</span><span class="info-value">{{ $candidate->phone_alternative ?? 'N/A' }}</span></div>
      </div>

      {{-- Alamat --}}
      <div class="info-card">
        <h3 class="info-card-title"><i class="fas fa-home"></i>Alamat</h3>
        <div class="info-row"><span class="info-label">Alamat Saat Ini</span><span class="info-value">{{ $candidate->current_address ?? 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">Status Tempat Tinggal</span><span class="info-value">{{ $candidate->current_address_status ?? 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">Alamat KTP</span><span class="info-value">{{ $candidate->ktp_address ?? 'N/A' }}</span></div>
      </div>

      {{-- Fisik & Kesehatan --}}
      <div class="info-card">
        <h3 class="info-card-title"><i class="fas fa-ruler-vertical"></i>Data Fisik & Kesehatan</h3>
        <div class="info-row"><span class="info-label">Tinggi Badan</span><span class="info-value">{{ $candidate->height_cm ? $candidate->height_cm.' cm' : 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">Berat Badan</span><span class="info-value">{{ $candidate->weight_kg ? $candidate->weight_kg.' kg' : 'N/A' }}</span></div>
        <div class="info-row"><span class="info-label">Status Vaksinasi</span><span class="info-value">{{ $candidate->vaccination_status ?? 'N/A' }}</span></div>
      </div>
    </div>

    {{-- Keluarga --}}
    @if($candidate->familyMembers->count() > 0)
      <h3 class="info-card-title" style="margin-top:30px;"><i class="fas fa-users"></i>Data Keluarga</h3>
      <table class="data-table">
        <thead>
          <tr><th>Hubungan</th><th>Nama</th><th>Usia</th><th>Pendidikan</th><th>Pekerjaan</th></tr>
        </thead>
        <tbody>
          @foreach($candidate->familyMembers as $member)
            <tr>
              <td>{{ $member->relationship ?? 'N/A' }}</td>
              <td>{{ $member->name ?? 'N/A' }}</td>
              <td>{{ $member->age ? $member->age.' tahun' : 'N/A' }}</td>
              <td>{{ $member->education ?? 'N/A' }}</td>
              <td>{{ $member->occupation ?? 'N/A' }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    @endif
  </section>

  {{-- ===== Pendidikan ===== --}}
  <section id="education-section" class="content-section">
    <h2 class="section-title"><i class="fas fa-graduation-cap"></i>Pendidikan</h2>
    @php
      $formalEducation = $candidate->formalEducation;
      $nonFormalEducation = $candidate->nonFormalEducation;
    @endphp

    @if($formalEducation->count())
      <h3 class="info-card-title"><i class="fas fa-university"></i>Pendidikan Formal</h3>
      <table class="data-table">
        <thead><tr><th>Jenjang</th><th>Institusi</th><th>Jurusan</th><th>Tahun</th><th>IPK</th></tr></thead>
        <tbody>
          @foreach($formalEducation as $edu)
            <tr>
              <td>{{ $edu->education_level ?? 'N/A' }}</td>
              <td>{{ $edu->institution_name ?? 'N/A' }}</td>
              <td>{{ $edu->major ?? 'N/A' }}</td>
              <td>{{ $edu->start_year }} - {{ $edu->end_year ?? 'Sekarang' }}</td>
              <td>{{ $edu->gpa ?? 'N/A' }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    @endif

    @if($nonFormalEducation->count())
      <h3 class="info-card-title" style="margin-top:30px;"><i class="fas fa-certificate"></i>Pendidikan Non-Formal</h3>
      <table class="data-table">
        <thead><tr><th>Nama Kursus/Pelatihan</th><th>Penyelenggara</th><th>Tanggal</th><th>Keterangan</th></tr></thead>
        <tbody>
          @foreach($nonFormalEducation as $course)
            <tr>
              <td>{{ $course->course_name ?? 'N/A' }}</td>
              <td>{{ $course->organizer ?? 'N/A' }}</td>
              <td>{{ $course->date ? \Carbon\Carbon::parse($course->date)->format('d M Y') : 'N/A' }}</td>
              <td>{{ $course->description ?? '-' }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    @endif

    @if(!$formalEducation->count() && !$nonFormalEducation->count())
      <div class="empty-state"><i class="fas fa-graduation-cap"></i><p>Tidak ada data pendidikan</p></div>
    @endif
  </section>

  {{-- ===== Pengalaman ===== --}}
  <section id="experience-section" class="content-section">
    <h2 class="section-title"><i class="fas fa-briefcase"></i>Pengalaman Kerja</h2>
    @if($candidate->workExperiences->count())
      @foreach($candidate->workExperiences as $exp)
        <div class="info-card" style="margin-bottom:20px;">
          <h3 class="info-card-title"><i class="fas fa-building"></i>{{ $exp->company_name ?? 'N/A' }}</h3>
          <div class="info-row"><span class="info-label">Posisi</span><span class="info-value">{{ $exp->position ?? 'N/A' }}</span></div>
          <div class="info-row"><span class="info-label">Periode</span><span class="info-value">{{ $exp->start_year ?? 'N/A' }} - {{ $exp->end_year ?? 'Sekarang' }}</span></div>
          <div class="info-row"><span class="info-label">Alamat Perusahaan</span><span class="info-value">{{ $exp->company_address ?? 'N/A' }}</span></div>
          <div class="info-row"><span class="info-label">Bidang Usaha</span><span class="info-value">{{ $exp->company_field ?? 'N/A' }}</span></div>
          <div class="info-row">
            <span class="info-label">Gaji Terakhir</span>
            <span class="info-value">{{ $exp->salary ? 'Rp '.number_format($exp->salary,0,',','.') : 'N/A' }}</span>
          </div>
          <div class="info-row"><span class="info-label">Alasan Berhenti</span><span class="info-value">{{ $exp->reason_for_leaving ?? 'N/A' }}</span></div>
          @if($exp->supervisor_contact)
            <div class="info-row"><span class="info-label">Kontak Atasan</span><span class="info-value">{{ $exp->supervisor_contact }}</span></div>
          @endif
        </div>
      @endforeach
    @else
      <div class="empty-state"><i class="fas fa-briefcase"></i><p>Tidak ada pengalaman kerja</p></div>
    @endif
  </section>

  {{-- ===== Skills ===== --}}
  <section id="skills-section" class="content-section">
    <h2 class="section-title"><i class="fas fa-cogs"></i>Keterampilan</h2>

    <div class="info-grid">
      @if($candidate->languageSkills->count())
        <div class="info-card">
          <h3 class="info-card-title"><i class="fas fa-language"></i>Kemampuan Bahasa</h3>
          @foreach($candidate->languageSkills as $lang)
            <div class="info-row">
              <span class="info-label">{{ $lang->language ?? 'N/A' }}</span>
              <span class="info-value">Bicara: {{ $lang->speaking_level ?? 'N/A' }}, Tulis: {{ $lang->writing_level ?? 'N/A' }}</span>
            </div>
          @endforeach
        </div>
      @endif

      @if($candidate->additionalInfo && ($candidate->additionalInfo->hardware_skills || $candidate->additionalInfo->software_skills))
        <div class="info-card">
          <h3 class="info-card-title"><i class="fas fa-laptop"></i>Kemampuan Komputer</h3>
          @if($candidate->additionalInfo->hardware_skills)
            <div class="info-row"><span class="info-label">Hardware</span><span class="info-value">{{ $candidate->additionalInfo->hardware_skills }}</span></div>
          @endif
          @if($candidate->additionalInfo->software_skills)
            <div class="info-row"><span class="info-label">Software</span><span class="info-value">{{ $candidate->additionalInfo->software_skills }}</span></div>
          @endif
        </div>
      @endif

      @if($candidate->drivingLicenses->count())
        <div class="info-card">
          <h3 class="info-card-title"><i class="fas fa-car"></i>SIM yang Dimiliki</h3>
          @foreach($candidate->drivingLicenses as $license)
            <div class="info-row"><span class="info-label">SIM {{ $license->license_type }}</span><span class="info-value">✓</span></div>
          @endforeach
        </div>
      @endif
    </div>

    @if($candidate->additionalInfo && $candidate->additionalInfo->other_skills)
      <div class="info-card" style="margin-top:20px;">
        <h3 class="info-card-title"><i class="fas fa-star"></i>Kemampuan Lainnya</h3>
        <p class="info-text">{{ $candidate->additionalInfo->other_skills }}</p>
      </div>
    @endif

    @if(!$candidate->languageSkills->count() && (!$candidate->additionalInfo || (!$candidate->additionalInfo->hardware_skills && !$candidate->additionalInfo->software_skills && !$candidate->additionalInfo->other_skills)) && !$candidate->drivingLicenses->count())
      <div class="empty-state"><i class="fas fa-cogs"></i><p>Tidak ada data keterampilan</p></div>
    @endif
  </section>

  {{-- ===== Aktivitas & Prestasi ===== --}}
  <section id="activities-section" class="content-section">
    <h2 class="section-title"><i class="fas fa-hands-helping"></i>Aktivitas & Prestasi</h2>
    @php
      $socialActivities = $candidate->activities->where('activity_type','social_activity');
      $achievements = $candidate->activities->where('activity_type','achievement');
    @endphp

    @if($socialActivities->count())
      <h3 class="info-card-title"><i class="fas fa-users"></i>Kegiatan Sosial/Organisasi</h3>
      <table class="data-table">
        <thead><tr><th>Nama Organisasi</th><th>Bidang</th><th>Periode</th><th>Keterangan</th></tr></thead>
        <tbody>
          @foreach($socialActivities as $activity)
            <tr>
              <td>{{ $activity->title ?? 'N/A' }}</td>
              <td>{{ $activity->field_or_year ?? 'N/A' }}</td>
              <td>{{ $activity->period ?? 'N/A' }}</td>
              <td>{{ $activity->description ?? '-' }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    @endif

    @if($achievements->count())
      <h3 class="info-card-title" style="margin-top:30px;"><i class="fas fa-trophy"></i>Prestasi</h3>
      <table class="data-table">
        <thead><tr><th>Nama Prestasi</th><th>Tahun</th><th>Keterangan</th></tr></thead>
        <tbody>
          @foreach($achievements as $achievement)
            <tr>
              <td>{{ $achievement->title ?? 'N/A' }}</td>
              <td>{{ $achievement->field_or_year ?? 'N/A' }}</td>
              <td>{{ $achievement->description ?? '-' }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    @endif

    @if(!$socialActivities->count() && !$achievements->count())
      <div class="empty-state"><i class="fas fa-hands-helping"></i><p>Tidak ada data aktivitas atau prestasi</p></div>
    @endif
  </section>

  {{-- ===== KRAEPLIN (partial) ===== --}}
  @include('candidates.partials.kraeplin-results', ['candidate' => $candidate])

  {{-- ===== DISC (partial) ===== --}}
  @include('candidates.partials.disc-results', ['candidate' => $candidate])

  {{-- ===== Dokumen ===== --}}
  <section id="documents-section" class="content-section">
    <h2 class="section-title"><i class="fas fa-file-alt"></i>Dokumen</h2>

    @if($candidate->documentUploads->count())
      <div class="documents-grid">
        @php
          $documentTypes = [
            'cv'          => ['icon' => 'fa-file-alt',   'label' => 'CV/Resume'],
            'photo'       => ['icon' => 'fa-image',      'label' => 'Foto'],
            'transcript'  => ['icon' => 'fa-file-pdf',   'label' => 'Transkrip Nilai'],
            'certificates'=> ['icon' => 'fa-certificate','label' => 'Sertifikat'],
          ];
        @endphp

        @foreach($documentTypes as $type => $config)
          @php $documents = $candidate->documentUploads->where('document_type', $type); @endphp
          <div class="document-category">
            <h3 class="document-category-title">
              <i class="fas {{ $config['icon'] }}"></i> {{ $config['label'] }}
              <span class="muted">({{ $documents->count() }} file{{ $documents->count() > 1 ? 's' : '' }})</span>
            </h3>

            @if($documents->count())
              @foreach($documents as $doc)
                <div class="document-item">
                  <div class="document-info">
                    <div class="document-icon"><i class="fas {{ $config['icon'] }}"></i></div>
                    <div class="document-details">
                      <div class="document-name">{{ $doc->document_name ?: $doc->original_filename ?: 'Dokumen' }}</div>
                      <div class="document-meta">
                        {{ $doc->file_size ? number_format($doc->file_size/1024,2).' KB' : 'Unknown size' }} •
                        {{ $doc->created_at->format('d M Y') }}
                      </div>
                    </div>
                  </div>
                  <div class="document-actions">
                    <a href="{{ Storage::url($doc->file_path) }}" target="_blank" class="btn btn-primary btn-small"><i class="fas fa-eye"></i></a>
                    <a href="{{ Storage::url($doc->file_path) }}" download class="btn btn-secondary btn-small"><i class="fas fa-download"></i></a>
                  </div>
                </div>
              @endforeach
            @else
              <div class="no-documents"><i class="fas {{ $config['icon'] }}"></i><p>Tidak ada {{ strtolower($config['label']) }}</p></div>
            @endif
          </div>
        @endforeach
      </div>
    @else
      <div class="empty-state"><i class="fas fa-file-alt"></i><p>Tidak ada dokumen yang diupload</p></div>
    @endif
  </section>

  {{-- ===== Modals ===== --}}
  <div id="historyModal" class="modal">
    <div class="modal-content" style="max-width:600px;">
      <div class="modal-header">
        <h2 class="modal-title">Riwayat Aktivitas</h2>
        <span class="close" onclick="closeHistoryModal()">&times;</span>
      </div>
      <div class="modal-body" style="max-height:400px;overflow:auto;">
        @if($candidate->applicationLogs->count())
          <div class="timeline">
            @foreach($candidate->applicationLogs->sortByDesc('created_at') as $log)
              <div class="timeline-item">
                <div class="timeline-header">
                  <div class="timeline-title">{{ $log->action_description }}</div>
                  <div class="timeline-date">{{ $log->created_at->format('d M Y H:i') }}</div>
                </div>
                @if($log->user)
                  <div class="timeline-content">Oleh: {{ $log->user->full_name }}</div>
                @endif
              </div>
            @endforeach
          </div>
        @else
          <div class="empty-state"><i class="fas fa-history"></i><p>Tidak ada riwayat aktivitas</p></div>
        @endif
      </div>
    </div>
  </div>

  <div id="statusModal" class="modal">
    <div class="modal-content">
      <div class="modal-header">
        <h2 class="modal-title">Update Status Kandidat</h2>
        <span class="close" onclick="closeStatusModal()">&times;</span>
      </div>
      <form id="statusForm" class="modal-body">
        <div class="form-group">
          <label class="form-label">Status Baru</label>
          <select id="newStatus" class="form-select" required>
            <option value="">Pilih Status</option>
            <option value="screening">Screening</option>
            <option value="interview">Interview</option>
            <option value="offered">Offered</option>
            <option value="accepted">Accepted</option>
            <option value="rejected">Rejected</option>
          </select>
        </div>
        <div class="form-group">
          <label class="form-label">Catatan (Opsional)</label>
          <textarea id="statusNotes" class="form-textarea" placeholder="Tambahkan catatan..."></textarea>
        </div>
        <div class="modal-actions">
          <button type="button" class="btn btn-secondary" onclick="closeStatusModal()">Batal</button>
          <button type="submit" class="btn btn-primary">Update Status</button>
        </div>
      </form>
    </div>
  </div>
@endsection

@push('scripts')
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

  <script>
    window.candidateDetailConfig = {
      updateStatusUrl: @json(route('candidates.update-status', $candidate->id)),
      kraeplinData: null,
      discData: null
    };
  </script>

  <script src="{{ asset('js/kraeplin-chart.js') }}" defer></script>
  <script src="{{ asset('js/disc-3d-manager.js') }}" defer></script>
  <script src="{{ asset('js/candidate-detail.js') }}" defer></script>

  {{-- Modal + Update Status --}}
  <script>
    const historyModal = document.getElementById('historyModal');
    const statusModal  = document.getElementById('statusModal');

    function showHistoryModal(){ historyModal?.classList.add('show'); }
    function closeHistoryModal(){ historyModal?.classList.remove('show'); }
    function showStatusModal(){ statusModal?.classList.add('show'); }
    function closeStatusModal(){ statusModal?.classList.remove('show'); }

    (function(){
      const form = document.getElementById('statusForm');
      if(!form) return;
      form.addEventListener('submit', async (e)=>{
        e.preventDefault();
        const status = document.getElementById('newStatus').value;
        const notes  = document.getElementById('statusNotes').value;
        if(!status){ document.getElementById('newStatus').focus(); return; }

        try{
          const res = await fetch(window.candidateDetailConfig.updateStatusUrl, {
            method: 'POST',
            headers: {
              'Content-Type':'application/json',
              'X-CSRF-TOKEN':'{{ csrf_token() }}',
              'Accept':'application/json'
            },
            body: JSON.stringify({ status, notes })
          });
          const data = await res.json();
          if(data.success){
            closeStatusModal();
            alert(data.message || 'Status diperbarui');
            window.location.reload();
          }else{
            alert(data.message || 'Gagal memperbarui status');
          }
        }catch(err){
          console.error(err);
          alert('Terjadi kesalahan jaringan.');
        }
      });
    })();
  </script>

  {{-- Sticky/FIxed + Smooth Scroll + ScrollSpy yang presisi --}}
  <script>
    (function(){
      const nav     = document.getElementById('sectionNav');
      const spacer  = document.getElementById('sectionNavSpacer');
      const links   = [...(nav?.querySelectorAll('.section-nav-link') || [])];

      const sectionIds = [
        'personal-section','education-section','experience-section','skills-section',
        'activities-section','general-section','kraeplin-section','disc-section','documents-section'
      ];
      const sections = sectionIds
        .map(id => document.getElementById(id))
        .filter(Boolean);

      // --- Hitung tinggi header atas yang fixed/sticky ---
      function computeStickTop(){
        const hdrs = document.querySelectorAll('.app-header,.topbar,.navbar,.main-header,.site-header,.header,header');
        let topPadding = 0;
        hdrs.forEach(el=>{
          const cs = getComputedStyle(el);
          const pos = cs.position;
          const rect = el.getBoundingClientRect();
          // ambil elemen fixed/sticky yang nempel di atas
          if((pos === 'fixed' || pos === 'sticky') && rect.bottom > 0 && rect.top <= 0){
            topPadding = Math.max(topPadding, rect.height);
          }
        });
        // fallback default
        if(topPadding === 0) topPadding = 72;
        document.documentElement.style.setProperty('--stickTop', (topPadding + 8) + 'px');
        return topPadding + 8;
      }

      // --- Fallback ke fixed ketika sticky gagal karena parent overflow ---
      let navTopPage = 0;    // posisi awal nav terhadap page
      function recalcNavMetrics(){
        const rect = nav.getBoundingClientRect();
        navTopPage = window.scrollY + rect.top; // Y absolut
        document.documentElement.style.setProperty('--navWidth', rect.width + 'px');
        document.documentElement.style.setProperty('--navLeft', (rect.left + window.scrollX) + 'px');
        document.documentElement.style.setProperty('--navHeight', rect.height + 'px');
      }

      function toggleFixedFallback(){
        const stickTop = computeStickTop(); // pastikan nilai terbaru
        const shouldFix = window.scrollY + stickTop > navTopPage;
        nav.classList.toggle('is-fixed', shouldFix);
        spacer.style.height = shouldFix ? getComputedStyle(document.documentElement).getPropertyValue('--navHeight') : '0px';
      }

      // --- Smooth scroll dengan offset aman (tidak ketutup header) ---
      function scrollToWithOffset(id){
        const el = document.getElementById(id);
        if(!el) return;
        const stickTop = parseInt(getComputedStyle(document.documentElement).getPropertyValue('--stickTop')) || 80;
        const y = window.scrollY + el.getBoundingClientRect().top - stickTop - 12;
        window.scrollTo({ top: y, behavior: 'smooth' });
      }

      links.forEach(a=>{
        a.addEventListener('click', (e)=>{
          const href = a.getAttribute('href') || '';
          if(href.startsWith('#')){
            e.preventDefault();
            const id = href.slice(1);
            // set active langsung biar responsif
            links.forEach(x=>x.classList.remove('active'));
            a.classList.add('active');
            history.replaceState(null,'', '#' + id);
            scrollToWithOffset(id);
          }
        });
      });

      // --- ScrollSpy manual (presisi, bebas dari IO offset) ---
      let rafId = 0;
      function onScroll(){
        if(rafId) return;
        rafId = requestAnimationFrame(()=>{
          rafId = 0;
          toggleFixedFallback(); // jaga posisi nav

          const stickTop = parseInt(getComputedStyle(document.documentElement).getPropertyValue('--stickTop')) || 80;
          const cursorY = window.scrollY + stickTop + 24;

          // cari section yang sedang "aktif" (area di bawah header)
          let current = sections[0]?.id;
          for(const sec of sections){
            const rect = sec.getBoundingClientRect();
            const top = window.scrollY + rect.top;
            const bottom = top + rect.height;
            if(cursorY >= top && cursorY < bottom){
              current = sec.id; break;
            }
          }
          // update active link
          if(current){
            links.forEach(x=>x.classList.remove('active'));
            const active = nav.querySelector(`a.section-nav-link[href="#${current}"]`);
            active?.classList.add('active');
          }
        });
      }

      // --- Init ---
      if(nav){
        computeStickTop();
        recalcNavMetrics();
        toggleFixedFallback();
        window.addEventListener('scroll', onScroll, { passive:true });
        window.addEventListener('resize', ()=>{
          computeStickTop();
          recalcNavMetrics();
          toggleFixedFallback();
          onScroll();
        });

        // kalau buka dengan hash, offset langsung diperbaiki
        window.addEventListener('load', ()=>{
          if(location.hash){
            setTimeout(()=>scrollToWithOffset(location.hash.replace('#','')), 0);
          }
        });
      }
    })();
  </script>
@endpush
